set sql_safe_updates=0;

SET @extUserDtProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ADD_EXTERNAL_USER_VELOCITY_RECIPIENT_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`printName` AS STUDENT_PRINT_NAME,
    T6.`emailId` AS EMAIL_ID,
    T6.`mobileNumber` AS MOBILE_NO,
    T6.`mobileCountryCode` AS MOBILE_CODE,
    T6.`firstName` AS PARENT_FIRSTNAME,
    T6.`lastName` AS PARENT_LASTNAME,
    T6.`printName` AS PARENT_PRINT_NAME,
    T3.`code` AS APPLICATION_CODE,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT JOIN
    applicant_person_relationships T5 ON T5.applicantPersonId = T4.id
        LEFT JOIN
    applicant_person T6 ON T6.id = T5.relatedApplicantPersonId
        LEFT OUTER JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams)
        AND T5.relationship = 'FATHER'",`jsonString`='{
        "id": 1,
        "searchResultViewColumns": [
            {
                "id": 3,
                "value": "firstName",
                "resultKey": "FIRST_NAME",
                "displayCode": "",
                "displayOrder": 2
            },
            {
                "id": 4,
                "value": "middleName",
                "resultKey": "MIDDLE_NAME",
                "displayCode": "",
                "displayOrder": 3
            },
            {
                "id": 5,
                "value": "lastName",
                "resultKey": "LAST_NAME",
                "displayCode": "",
                "displayOrder": 4
            },
            {
                "id": 6,
                "value": "emailId",
                "resultKey": "EMAIL_ID",
                "displayCode": "",
                "displayOrder": 5
            },
            {
                "id": 7,
                "value": "mobileNumber",
                "resultKey": "MOBILE_NO",
                "displayCode": "",
                "displayOrder": 6
            },
            {
                "id": 8,
                "value": "code",
                "resultKey": "APPLICATION_CODE",
                "displayCode": "",
                "displayOrder": 7
            },		 
    		{
                "id": 9,
                "value": "firstName",
                "resultKey": "PARENT_FIRSTNAME",
                "displayCode": "",
                "displayOrder": 8
            },
    		{
                "id": 10,
                "value": "lastName",
                "resultKey": "PARENT_LASTNAME",
                "displayCode": "",
                "displayOrder": 9
            },
    		{
                "id": 11,
                "value": "shortName",
                "resultKey": "STUDENT_PRINT_NAME",
                "displayCode": "",
                "displayOrder": 10
            },
    		{
                "id": 12,
                "value": "shortName",
                "resultKey": "PARENT_PRINT_NAME",
                "displayCode": "",
                "displayOrder": 11
            },
            {
                "id": 13,
                "value": "logoUrl",
                "resultKey": "LOGO_URL",
                "displayCode": "",
                "displayOrder": 12
            }
        ]
    }' WHERE `dataProviderId`=@extUserDtProviderId;
		
SET @msgTemplateConfigId=(select id from msg_template_config where sysMsgEventId =(select id from system_msg_event where code='ADD_EXTERNAL_USER_VELOCITY'));

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear<strong>&nbsp;$recipientData[&quot;PARENT_PRINT_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thank you for submitting your application and paying the application fee. We are delighted that you are considering $templateData[&quot;ACADEMY_NAME_LOCATION&quot;] $templateData[&quot;GROUP_NAME&quot;].</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">As soon as we have reviewed your application we will contact you to discuss the next steps which may include an interview or an assessment. These will be set up on a date and at a time that suits you.</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">The login details that you can use to access our Application Portal where you can monitor the progress of your application are below. Once you have been enrolled at our school you will get new login details that you will be able to use for the duration of your relationship with us to access a portal containing all the important information and history and correspondence you will require.</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">URL:&nbsp;<a href="https://stasy.iie.edu.za/">https://stasy.iie.edu.za/</a><br />
			Username:&nbsp;$templateData[&quot;LOGIN_ID&quot;]<br />
			Password:&nbsp;$templateData[&quot;PASSWORD&quot;]</span></span></p>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">To help us provide you with the best possible service please log in soon and check all the following information for completeness and accuracy:</span></span></p>

			<ul>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Address information;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Contact details for parents or guardians;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Fee payer information;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Education history;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Medical information;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Any pending documentation;</span></span></li>
				<li><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Any additional student information.</span></span></li>
			</ul>

			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">We look forward to engaging with you further. Please expect to hear from us soon.</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			<span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,<br />
			<strong>$templateData[&quot;ACADEMY_NAME_LOCATION&quot;] $templateData[&quot;GROUP_NAME&quot;]</strong></span></span></p>

			<p>&nbsp;</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #d1d1d1; margin:0px; padding:4px;"><img height="80" src=" $recipientData[&quot;LOGO_URL&quot;]" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE msgTemplateConfigId=@msgTemplateConfigId and msgDeliveryModeId in (1);

set sql_safe_updates=1;
